#include "BOLTApp.h"
#include "db/BOLTdb.h"
#include "db/BOLTdbConfig.h"

#include "ctrl/BOLTChooser.h"
#include "ctrl/BOLTUser.h"
#include "BOLTFrm.h"
#include "form/BOLTforms.h"

#include "form/bfHome.h"
#include "wx/valtext.h"
#include "wx/datetime.h"
#include "wx/statline.h"
#include "wx/memory.h"

IMPLEMENT_DYNAMIC_CLASS(bfHome,BOLTPage)
BEGIN_EVENT_TABLE(bfHome,BOLTPage)
EVT_BUTTON(ID_REPORTS,bfHome::OnButton)
EVT_BUTTON(ID_SETTINGS,bfHome::OnButton)
EVT_BUTTON(ID_TOOLS,bfHome::OnButton)
END_EVENT_TABLE()

bfHome::bfHome(wxNotebook *parent,BOLTdb *db):
	BOLTPage(parent,-1,wxDefaultPosition,wxDefaultSize,wxTAB_TRAVERSAL|wxWANTS_CHARS,"Home")
{
	this->db=db;
	created=false;
	Freeze();
	wxBoxSizer *winSizer = new wxBoxSizer(wxVERTICAL);
	wxBoxSizer *topSizer = new wxBoxSizer(wxHORIZONTAL);
	wxBoxSizer *tSizer,*thSizer;
	wxStaticBoxSizer *tSBS;
	wxString tStr;
	if (!user || !db) { Close(true); };
	wxFont tFont;
	wxButton *tButton;
	wxStaticBox *tSB=NULL;

#define SGADD(b,h,c,t,tbl,tvar,tid,bvar,bid) tSBS=new wxStaticBoxSizer(\
		tSB=new wxStaticBox(this,-1,t),wxVERTICAL); \
		tSB->SetBackgroundColour(c); \
		tSBS->Add(tButton=b,0,wxALL|wxALIGN_CENTER,5); \
		tButton->SetToolTip(h); \
		tSBS->Add(tvar=new wxTextCtrl(this,tid),0,wxALL|wxEXPAND,2); \
		tvar->SetBackgroundColour(c); \
		tvar->SetToolTip(h); \
		tSBS->Add(bvar=new wxButton(this,bid,"New"),0,wxALL|wxEXPAND,5); \
		bvar->SetBackgroundColour(c); \
		bvar->SetToolTip(h); \
		tSizer->Add(tSBS,1,wxALIGN_CENTER|wxALL,3);


#define SBADD(b,t,h,c) tSBS=new wxStaticBoxSizer(\
		tSB=new wxStaticBox(this,-1,t),wxVERTICAL); \
		tSBS->Add(tButton=b,1,wxALIGN_CENTER|wxALL,5); \
		tButton->SetName("1"); \
		tButton->SetToolTip(h); \
		thSizer->Add(tSBS,1,wxALIGN_CENTER|wxALL,3);

	thSizer=new wxBoxSizer(wxVERTICAL);
	SBADD(BUTTON_REPORTS,"&Reports",HELP_REPORTS,COLOR_REPORT);
	SBADD(BUTTON_TOOLS,"T&ools",HELP_TOOLS,COLOR_HOME);
	SBADD(BUTTON_LOGOUT,"&Logout",HELP_LOGOUT,"");
	topSizer->Add(thSizer,1,wxALIGN_CENTER|wxALL,15);
	
	winSizer->Add(topSizer,0,wxEXPAND|wxALL,1);
//	SetAutoLayout(TRUE);
	SetSizerAndFit(winSizer);

	  wxAcceleratorEntry entries[3];
  entries[0].Set(wxACCEL_ALT,  (int) 'R',     ID_REPORTS);
  entries[1].Set(wxACCEL_ALT,  (int) 'O',     ID_SETTINGS);
  entries[2].Set(wxACCEL_ALT,  (int) 'L',     ID_LOGOUT);
  wxAcceleratorTable accel(3, entries);
  SetAcceleratorTable(accel);
  FitInside();
  Thaw();
  created=true;
};

void	bfHome::OnTextEnter(wxCommandEvent &evt)
{
	if (!db) { return; }
};

void	bfHome::OnButton(wxCommandEvent &evt)
{
	BOLTChooser *bc;
	RECORD_ID recId=0;
	wxArrayString fArray;
	wxString table;

	int fId=evt.GetId();

	switch (fId)
	{
	case ID_SETTINGS:
	case ID_TOOLS:
		recId=1;
		break;
	case ID_REPORTS:
		recId=ID_INVAL;
		break;
	}
	wxGetApp().frame->DispatchForm(fId,recId);
};

void	bfHome::OnTextEdit(wxCommandEvent &evt)
{
	if (!created) { return;} 
	if (!db) { return; }
};

void bfHome::OnTransactionButton(wxCommandEvent &event)
{
}

bfHome::bfHome():BOLTPage(wxGetApp().frame->nbWin,ID_HOME,wxDefaultPosition,wxDefaultSize,wxTAB_TRAVERSAL|wxWANTS_CHARS,"Home")
{
	bfHome(wxGetApp().frame->nbWin,wxGetApp().frame->db);
}
